function [NT_average, fusion_times, EPSC, time, EPSC_single, RRP, NT_single] = StochasticSytSimulation_Casignal_varPIP(Casignal, par_int, nVes, varRRP, varSlotIO, varSytIO, DN_IO, n_rep, varPIPIO)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%This function generates EPSCs simulated following a Ca-transient by using
%stochastic simulations using a Gillespy algorithm

%Input:
%Casignal - matrix with Ca2+ transient and the corresponding time
%par_int - used model parameters
%nVes - average number of vesicles for simulation
%varRRP - 0 for not variable RRP, two values (mean +sd) for generating RRP
%distribution following gamma distributiuon or an array of RRP sizes. 
%VarSlotIO - Not implemented
%VarSytIO - I for investigating variability in syt number
%DN_IO - 0 for not evaluating mutants, array with 4 values for evaluating
%mutants [fold change KDpip, Fold change KD ca, fold change konCa, A]
%n_rep - number of stochastic repetitions
%VarPIPIP - 0 if wanting constant PIP, 4 new variable if simulating with
%variable PIP [1. tau (of exponential), 2. time point of inflexion (s),3. par_int(4)/this number = maximum PIP2 concentration, par_int(4)/this number - Min PIP2 concentration ]

%Output:
%NT_average - Average sampled fusion times
%Fusion Times - Fusion times of all vesicles 
%EPSC - Average EPSC generated
%Time- Time points in the individual simulations
%EPSC_single - Individual EPSCs for all repetitions
%RRP - Size of the RRP for each repetition
%NT_single - Sampled fusion times for each repetition


Ca0 = 0.05; %resting Ca concentration



%Script needs to be adjusted still to allowing variable syts and var slot
if varSlotIO
    disp('ERROR: script still needs to be adjusted to allowing variable number of slots')
end

if varRRP
    nVes = 15000;
end

%Compute steady state distribution
if varSytIO
    Steady_rest = cell(50,1);
    for nsyt = 1:50
        par_int(8) = nsyt;
        par_int(11) = nsyt; % how many wt proteins
        Steady_rest{nsyt} = steady_state_newmethod_mutant(par_int, Ca0, DN_IO);
    end
else
    if varPIPIO
        par_int2 = par_int;
        par_int2(4) = par_int(4)/varPIPIO(4);
        [Steady_rest] = steady_state_newmethod_mutant(par_int2, Ca0, DN_IO);
    else
        par_int2 = par_int;
        [Steady_rest] = steady_state_newmethod_mutant(par_int, Ca0, DN_IO);
    end
end


if varSlotIO
    maxcross_var = round(randn(1,nVes)*0.75+3);
else
    maxcross_var =0;
end

if length(varRRP) ==2 
    nves_mean = varRRP(1);
    nves_sd = varRRP(2);
    k_gamma = (nves_mean^2)/(nves_sd^2);
    thet_gamma = (nves_sd^2)/nves_mean;
    RRP = round(gamrnd(k_gamma, thet_gamma, 1, n_rep));
elseif length(varRRP) >2
    RRP = varRRP;
else
    RRP = ones(1, n_rep)*nVes;
end    

fusion_times =zeros(nVes,n_rep);
sampling_rate=50e3;
end_time=Casignal(end,1);
time_sample=0:1/sampling_rate:end_time;

time = cell(1,n_rep);

parfor nn=1:n_rep
    nVes_round = RRP(nn);
    if varSytIO
    syt_var_round = poissrnd(15,1,nVes_round);
    %if any zero syt value: 
    syt_var_round(syt_var_round==0)=1;
    [Steady] = make_SS_stoch_nsytvar(Steady_rest, nVes_round, par_int, syt_var_round);
    else
    Steady_round = Steady_rest;
    if varPIPIO
         [Steady] = make_SS_stoch_mut(Steady_round, nVes_round, par_int2);
    else
    [Steady] = make_SS_stoch_mut(Steady_round, nVes_round, par_int);
    end
    end
    if (varSlotIO || varSytIO ) &&DN_IO
        disp('ERROR: not implemented combination of mutant and variable syt')
    elseif ~varSlotIO & ~varSytIO & length(DN_IO)==4
    [fusion_times(:,nn), ~, time{nn}]=directMethod_SingleSyt_Casignal2(Steady, par_int, Casignal, nVes,0, DN_IO); 
    elseif (varSlotIO || varSytIO) && ~DN_IO
            [fusion_times(:,nn), ~, time{nn}]=directMethod_SingleSyt_Casignal1(Steady, par_int, Casignal, nVes, 0, syt_var_round);
    else
    [fusion_times(:,nn), ~, time{nn}]=directMethod_SingleSyt_Casignal_varPIP(Steady, par_int, Casignal, nVes,0, varPIPIO);
    end

end

for i=1:length(time_sample)
    NT(i,:)=sum(fusion_times<time_sample(i)); %cumulative fusion
end
     NT_average=diff(mean(NT,2));
     NT_single = diff(NT,1);
     

s = load('mEPSC_new.mat');
mEPSC = s.mEPSC;
EPSC = conv(NT_average, mEPSC); 
parfor nn=1:n_rep
EPSC_single(:, nn) = conv(NT_single(:,nn), mEPSC); 
end